rule Linux_Ransomware_GwisinLocker : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "GWISINLOCKER"
        description         = "Yara rule that detects GwisinLocker ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "GwisinLocker"
        tc_detection_factor = 5

    strings:

        $init_key_v1 = {
            55 57 56 53 E8 ?? ?? ?? ?? 81 C3 ?? ?? ?? ?? 81 EC ?? ?? ?? ?? 8D 74 24 ?? 56 E8 ??
            ?? ?? ?? 83 C4 ?? 85 C0 74 ?? 31 FF 83 EC ?? 56 E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? 89
            F8 5B 5E 5F 5D C3 66 90 31 D2 31 C0 89 54 04 ?? 83 C0 ?? 83 F8 ?? 72 ?? 83 EC ?? 8D
            83 ?? ?? ?? ?? 50 8D 83 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 89 C5 8D 7C 24 ?? 85
            C0 74 ?? 50 6A ?? 6A ?? 57 E8 ?? ?? ?? ?? 89 2C 24 E8 ?? ?? ?? ?? 83 C4 ?? 83 EC ??
            6A ?? 57 56 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? C7 04 24 ?? ?? ?? ?? 83 EC ?? 8D 44
            24 ?? 50 FF B4 24 ?? ?? ?? ?? FF B4 24 ?? ?? ?? ?? FF B4 24 ?? ?? ?? ?? 6A ?? FF B3
            ?? ?? ?? ?? FF B4 24 ?? ?? ?? ?? 56 FF B3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0
            0F 94 C0 0F B6 C0 89 C7 E9
        }

        $encrypt_files_v1_p1 = {
            55 B9 ?? ?? ?? ?? 57 56 53 E8 ?? ?? ?? ?? 81 C3 ?? ?? ?? ?? 81 EC ?? ?? ?? ?? 8B 84
            24 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 44 24 ?? 8B 84 24
            ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 44 24 ?? 8D 44 24 ?? 83 EC ?? 89 44 24 ?? 89
            C7 31 C0 F3 AB C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ??
            ?? 6A ?? FF 74 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8D 84 24 ?? ?? ?? ?? 89 44
            24 ?? 8D 84 24 ?? ?? ?? ?? 89 44 24 ?? 31 FF 83 EC ?? 68 ?? ?? ?? ?? FF 74 24 ?? E8
            ?? ?? ?? ?? 58 5A 6A ?? FF 74 24 ?? E8 ?? ?? ?? ?? 59 5E 6A ?? FF 74 24 ?? E8 ?? ??
            ?? ?? 81 C4 ?? ?? ?? ?? 89 F8 5B 5E 5F 5D C3 8D 74 26 ?? 90 83 EC ?? 6A ?? 8D 84 24
            ?? ?? ?? ?? 89 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D B4 24 ?? ?? ?? ?? 89 74 24 ??
            85 C0 74 ?? 83 EC ?? 6A ?? FF 74 24 ?? 56 E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? 59 5E 50
            89 C5 FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 ?? 89 C6 83 C4 ?? 85 C0 0F 84 ??
            ?? ?? ?? 83 EC ?? FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 50 89 C7 FF B4 24 ??
            ?? ?? ?? FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 94 24 ?? ?? ?? ?? 01 FA 89 D0 8B 54
            24 ?? 89 10 0F B7 54 24 ?? 66 89 50 ?? 0F B6 54 24 ?? 88 50 ?? 8B 94 24 ?? ?? ?? ??
            C6 44 3A ?? ?? BF ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 56 E8 ??
            ?? ?? ?? B9 ?? ?? ?? ?? 83 C4 ?? 39 C1 B9 ?? ?? ?? ?? 19 D1 7D ?? 83 EC ?? FF B4 24
            ?? ?? ?? ?? FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 ?? 83 EC ?? FF 74
            24 ?? E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 8D 74 26 ?? 90 83 EC ?? 56 E8 ?? ?? ??
            ?? 58 5A 55 FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 ?? 89 C6 83 C4 ?? 85 C0 0F
        }

        $encrypt_files_v1_p2 = {
            84 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 50 E8 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 8B 74 24
            ?? 8B 7C 24 ?? 89 D1 89 74 24 ?? 89 7C 24 ?? 83 C4 ?? 39 F0 19 F9 7D ?? 89 44 24 ??
            89 54 24 ?? 8B 7C 24 ?? 8B 74 24 ?? 89 F9 89 F5 C1 F9 ?? 89 C8 89 4C 24 ?? 31 CD 8B
            74 24 ?? C1 F8 ?? 89 44 24 ?? 89 E8 29 F0 8B 74 24 ?? 89 C7 83 E7 ?? 31 CF 89 F8 8B
            7C 24 ?? 29 F0 8B 74 24 ?? 89 FA 19 FA 8B 7C 24 ?? 29 C6 89 74 24 ?? 19 D7 83 EC ??
            89 7C 24 ?? 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 8D BC 24 ?? ?? ?? ?? 8D B4 24 ?? ?? ?? ??
            B9 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 31 C0 F3 AB 89 94 24 ?? ?? ?? ?? 56 6A ?? FF 74
            24 ?? FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 89 C7 85 C0 0F 84 ?? ?? ?? ?? 83
            EC ?? FF 74 24 ?? E8 ?? ?? ?? ?? 5F 5D FF B4 24 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4
            ?? 89 C7 85 C0 0F 84 ?? ?? ?? ?? 8B B4 24 ?? ?? ?? ?? 8B 54 24 ?? 31 FF 8B 44 24 ??
            89 7C 24 ?? 89 74 24 ?? 8D 74 24 ?? 89 D7 89 74 24 ?? 8D B3 ?? ?? ?? ?? 09 C7 89 74
        }

        $encrypt_files_v1_p3 = {
            24 ?? 0F 84 ?? ?? ?? ?? 8B 4C 24 ?? 8B 6C 24 ?? 89 4C 24 ?? EB ?? 66 90 83 EC ?? 31
            ED FF B4 24 ?? ?? ?? ?? FF B4 24 ?? ?? ?? ?? FF B4 24 ?? ?? ?? ?? FF 74 24 ?? FF 74
            24 ?? FF 74 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 31 D2 6A ?? 8B 84 24 ?? ?? ?? ?? 52 F7 D8
            50 57 E8 ?? ?? ?? ?? 57 FF B4 24 ?? ?? ?? ?? 6A ?? FF B4 24 ?? ?? ?? ?? E8 ?? ?? ??
            ?? 8B 44 24 ?? 8B BC 24 ?? ?? ?? ?? 8B 54 24 ?? 29 F8 19 EA 89 44 24 ?? 89 D6 89 54
            24 ?? 83 C4 ?? 09 C6 74 ?? 39 84 24 ?? ?? ?? ?? 89 E9 8B 7C 24 ?? 19 D1 0F 4C 84 24
            ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 89 44 24 ?? 8B 84 24 ?? ?? ??
            ?? 89 44 24 ?? 8B 84 24 ?? ?? ?? ?? 89 44 24 ?? 8B 84 24 ?? ?? ?? ?? 89 44 24 ?? 57
            FF B4 24 ?? ?? ?? ?? 6A ?? FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 39 84 24 ??
            ?? ?? ?? 0F 84 ?? ?? ?? ?? 83 EC ?? BF ?? ?? ?? ?? FF 74 24 ?? E8 ?? ?? ?? ?? 83 C4
            ?? E9 ?? ?? ?? ?? 83 EC ?? FF B4 24 ?? ?? ?? ?? FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ??
            83 C4 ?? E9
        }

        $find_files_v1_p1 = {
            55 89 C5 57 E8 ?? ?? ?? ?? 81 C7 ?? ?? ?? ?? 56 53 81 EC ?? ?? ?? ?? 89 54 24 ?? 8B
            B4 24 ?? ?? ?? ?? 89 7C 24 ?? 89 FB 89 4C 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 89 44 24
            ?? C7 44 24 ?? ?? ?? ?? ?? 85 C0 74 ?? 8D 58 ?? 80 7C 05 ?? ?? 0F 45 D8 89 5C 24 ??
            8B BC 24 ?? ?? ?? ?? 83 E7 ?? 74 ?? 83 EC ?? 8D 44 24 ?? 89 44 24 ?? 50 55 6A ?? 8B
            5C 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 ?? 8B 5C 24 ?? E8 ?? ?? ?? ?? 8B 00 83 F8
            ?? 0F 85 ?? ?? ?? ?? BF ?? ?? ?? ?? C6 44 24 ?? ?? C7 44 24 ?? ?? ?? ?? ?? EB ?? 8D
            B4 26 ?? ?? ?? ?? 66 90 83 EC ?? 8D 44 24 ?? 89 44 24 ?? 50 55 6A ?? 8B 5C 24 ?? E8
            ?? ?? ?? ?? 83 C4 ?? 85 C0 78 ?? 8B 84 24 ?? ?? ?? ?? 25 ?? ?? ?? ?? 3D ?? ?? ?? ??
            0F 84 ?? ?? ?? ?? 3D ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? C6 44 24 ?? ?? 31 FF C7 44 24 ??
            ?? ?? ?? ?? 8B 54 24 ?? 8B 44 24 ?? F6 84 24 ?? ?? ?? ?? ?? 74 ?? 85 F6 0F 84 ?? ??
            ?? ?? 8B 4E ?? 8B 5E ?? 31 D1 31 C3 09 CB 0F 84 ?? ?? ?? ?? 31 FF 81 C4 ?? ?? ?? ??
            89 F8 5B 5E 5F 5D C3 8D 74 26 ?? 90 8B 5C 24 ?? E8 ?? ?? ?? ?? 89 C7 8B 00 83 F8 ??
            0F 85 ?? ?? ?? ?? 83 EC ?? FF 74 24 ?? 55 6A ?? 8B 5C 24 ?? E8 ?? ?? ?? ?? 83 C4 ??
            85 C0 0F 85 ?? ?? ?? ?? BF ?? ?? ?? ?? C6 44 24 ?? ?? C7 44 24 ?? ?? ?? ?? ?? E9 ??
            ?? ?? ?? 8D 74 26 ?? 90 89 54 24 ?? 8B 94 24 ?? ?? ?? ?? 89 44 24 ?? 8B 84 24 ?? ??
            ?? ?? 89 74 24 ?? 89 44 24 ?? 89 54 24 ?? 85 F6 0F 84 ?? ?? ?? ?? 8B 46 ?? 8B 4C 24
            ?? 83 C0 ?? 83 C1 ?? 89 44 24 ?? 89 44 24 ?? 8B 46 ?? 89 4C 24 ?? 89 4C 24 ?? 89 44
        }

        $find_files_v1_p2 = {
            24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 83 FF ?? 0F 84 ?? ?? ?? ?? 8B
            84 24 ?? ?? ?? ?? 83 E0 ?? 89 44 24 ?? 75 ?? 8D 44 24 ?? 50 FF 74 24 ?? FF 74 24 ??
            55 8B 44 24 ?? FF D0 89 C7 83 C4 ?? 85 C0 0F 85 ?? ?? ?? ?? 85 F6 74 ?? 8B 84 24 ??
            ?? ?? ?? 8B 5C 24 ?? 89 6C 24 ?? 8B 4C 24 ?? 8B BC 24 ?? ?? ?? ?? 89 C5 EB ?? 8D B6
            ?? ?? ?? ?? 8B 36 85 F6 74 ?? 8B 46 ?? 8B 56 ?? 31 D8 31 CA 09 C2 75 ?? 8B 46 ?? 8B
            56 ?? 31 E8 31 FA 09 C2 0F 84 ?? ?? ?? ?? 8B 36 85 F6 75 ?? 8B 6C 24 ?? 8B 7C 24 ??
            85 FF 74 ?? 80 7C 24 ?? ?? 0F 85 ?? ?? ?? ?? 8B 44 24 ?? C6 44 05 ?? ?? 8B 44 24 ??
            85 C0 0F 84 ?? ?? ?? ?? 8D 44 24 ?? 50 FF 74 24 ?? FF 74 24 ?? 55 8B 44 24 ?? FF D0
            83 C4 ?? 89 C7 81 C4 ?? ?? ?? ?? 89 F8 5B 5E 5F 5D C3 66 90 83 EC ?? 6A ?? 55 8B 5C
            24 ?? E8 ?? ?? ?? ?? 8B 5C 24 ?? 89 44 24 ?? 89 C7 E8 ?? ?? ?? ?? 8B 00 89 44 24 ??
            83 C4 ?? 85 FF 79 ?? 83 F8 ?? 0F B6 4C 24 ?? BA ?? ?? ?? ?? 0F 94 C0 84 C0 B8 ?? ??
            ?? ?? 0F 44 44 24 ?? 0F 45 CA 89 44 24 ?? 88 4C 24 ?? 8B 44 24 ?? 85 C0 0F 85 ?? ??
            ?? ?? 83 EC ?? FF 74 24 ?? 8B 5C 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 8D B4
            26 ?? ?? ?? ?? 8D 76 ?? 89 54 24 ?? 8B 94 24 ?? ?? ?? ?? 89 44 24 ?? 8B 84 24 ?? ??
            ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 44 24 ?? 89 54 24 ?? 8B 44 24 ?? C7 44 24 ?? ?? ??
            ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8D 48 ?? 89 4C 24 ?? 89 4C 24 ?? 85 C0 74 ?? 80 7C 05
            ?? ?? 74 ?? E9 ?? ?? ?? ?? 8D 76 ?? 80 7C 05 ?? ?? 0F 85 ?? ?? ?? ?? 83 E8 ?? 75 ??
            31 D2 89 54 24 ?? E9 ?? ?? ?? ?? 8D 74 26 ?? 90 89 54 24 ?? 8B 94 24 ?? ?? ?? ?? 89
        }

        $find_files_v1_p3 = {
            44 24 ?? 8B 84 24 ?? ?? ?? ?? 89 74 24 ?? 89 44 24 ?? 89 54 24 ?? E9 ?? ?? ?? ?? 90
            8B 84 24 ?? ?? ?? ?? BF ?? ?? ?? ?? C6 44 24 ?? ?? 83 E0 ?? 83 F8 ?? 19 C0 83 E0 ??
            83 C0 ?? 89 44 24 ?? E9 ?? ?? ?? ?? 8D B4 26 ?? ?? ?? ?? 90 8B 74 24 ?? 85 F6 0F 88
            ?? ?? ?? ?? 83 EC ?? FF 74 24 ?? 8B 5C 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 89 C6 85 C0 0F
            84 ?? ?? ?? ?? B8 ?? ?? ?? ?? 2B 44 24 ?? 89 44 24 ?? 8D B4 26 ?? ?? ?? ?? 8D 76 ??
            83 EC ?? 56 8B 5C 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 ?? ?? ?? ?? 80 78 ?? ??
            0F 84 ?? ?? ?? ?? 83 EC ?? 8D 78 ?? 57 8B 5C 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 3B 44 24
            ?? 0F 83 ?? ?? ?? ?? 8B 44 24 ?? 83 EC ?? C6 44 05 ?? ?? 57 8B 44 24 ?? 01 E8 50 8B
            5C 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 5A 5B 8D 48 ?? 8D 44 24 ?? 50 89 E8 FF B4 24 ??
            ?? ?? ?? 8B 54 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 ?? ?? ?? ?? 83 EC ?? 89 C7
            56 8B 5C 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 66 90 80 78 ?? ?? 0F 84 ?? ??
            ?? ?? 66 83 78 ?? ?? 0F 85 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D B6 ?? ?? ?? ?? 80 7C 05 ??
            ?? 8D 48 ?? 89 C2 0F 84 ?? ?? ?? ?? 85 C9 0F 84 ?? ?? ?? ?? 80 7C 05 ?? ?? 8D 50 ??
            75 ?? E9 ?? ?? ?? ?? 8D B4 26 ?? ?? ?? ?? 66 90 89 C2 85 D2 0F 84 ?? ?? ?? ?? 80 7C
            15 ?? ?? 8D 42 ?? 75 ?? E9 ?? ?? ?? ?? 8D B4 26 ?? ?? ?? ?? 85 FF 0F 84 ?? ?? ?? ??
            31 FF C6 44 24 ?? ?? C7 44 24 ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 83 EC ?? 56 8B 5C 24 ??
            E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 8B 07 E9 ?? ?? ?? ?? 8B 7C 24 ?? 89 FB BF ??
            ?? ?? ?? E8 ?? ?? ?? ?? 83 EC ?? C7 00 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? E9 ??
            ?? ?? ?? BF
        }

        $kill_processes_v1_p1 = {
            55 BA ?? ?? ?? ?? B8 ?? ?? ?? ?? BD ?? ?? ?? ?? 57 89 E9 56 53 E8 ?? ?? ?? ?? 81 C3
            ?? ?? ?? ?? 81 EC ?? ?? ?? ?? 66 89 54 24 ?? 8D 7C 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7
            44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8D B3 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ??
            ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C6 44 24
            ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44
            24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C6 44 24 ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7
            44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 66 89 44 24 ??
            C6 44 24 ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ??
            ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C6 44 24 ?? ?? 8B 83 ?? ?? ?? ??
            89 44 24 ?? 8B 83 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? F3 A5 8D B4 24 ?? ?? ?? ?? C6 44
        }

        $kill_processes_v1_p2 = {
            24 ?? ?? 83 EC ?? C7 44 24 ?? ?? ?? ?? ?? 89 F7 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ??
            ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 CD C7 44 24 ?? ?? ??
            ?? ?? B9 ?? ?? ?? ?? 89 E8 F3 AB FF B4 24 ?? ?? ?? ?? 89 F7 8D 44 24 ?? 50 56 E8 ??
            ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 C4 ?? 89 E8 B9 ?? ?? ?? ?? F3 AB FF B4 24 ?? ??
            ?? ?? 89 F7 8D 44 24 ?? 50 56 E8 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 C4 ?? 89 E8
            B9 ?? ?? ?? ?? F3 AB FF B4 24 ?? ?? ?? ?? 89 F7 8D 44 24 ?? 50 56 E8 ?? ?? ?? ?? 89
            34 24 E8 ?? ?? ?? ?? 83 C4 ?? 89 E8 B9 ?? ?? ?? ?? F3 AB FF B4 24 ?? ?? ?? ?? 89 F7
            8D 44 24 ?? 50 56 E8 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 C4 ?? 89 E8 B9 ?? ?? ??
            ?? F3 AB FF B4 24 ?? ?? ?? ?? 89 F7 8D 84 24 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 89 34
            24 E8 ?? ?? ?? ?? 83 C4 ?? 89 E8 B9 ?? ?? ?? ?? F3 AB FF B4 24 ?? ?? ?? ?? 89 F7 8D
            44 24 ?? 50 56 E8 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 C4 ?? 89 E8 B9 ?? ?? ?? ??
            F3 AB FF B4 24 ?? ?? ?? ?? 8D 44 24 ?? 50 56 E8 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ??
            81 C4 ?? ?? ?? ?? 5B 5E 5F 5D C3
        }

        $shut_down_esxi_v1 = {
            55 B8 ?? ?? ?? ?? BD ?? ?? ?? ?? 57 89 C1 56 53 E8 ?? ?? ?? ?? 81 C3 ?? ?? ?? ?? 81 
            EC ?? ?? ?? ?? 8D 7C 24 ?? C7 44 24 ?? 65 73 78 63 C7 44 24 ?? 6C 69 20 76 C7 44 24 
            ?? 6D 20 70 72 8D B3 ?? ?? ?? ?? C7 44 24 ?? 6F 63 65 73 F3 A5 8D B4 24 ?? ?? ?? ?? 
            C7 44 24 ?? 73 20 6B 69 83 EC ?? 89 F7 C7 44 24 ?? 6C 6C 20 2D C7 44 24 ?? 2D 74 79 
            70 C7 44 24 ?? 65 3D 66 6F C7 44 24 ?? 72 63 65 20 C7 44 24 ?? 2D 2D 77 6F 89 C8 B9 
            ?? ?? ?? ?? C7 44 24 ?? 72 6C 64 2D C7 44 24 ?? 69 64 3D 22 C7 84 24 ?? ?? ?? ?? 25 
            73 22 00 C7 44 24 ?? 5B 45 53 58 C7 44 24 ?? 69 5D 20 53 C7 44 24 ?? 68 75 74 74 C7 
            44 24 ?? 69 6E 67 20 C7 44 24 ?? 64 6F 77 6E F3 AB C7 44 24 ?? 20 2D 20 25 8D 83 ?? 
            ?? ?? ?? 66 89 6C 24 ?? C6 44 24 ?? ?? 50 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83
            C4 ?? 85 C0 0F 84 ?? ?? ?? ?? BF ?? ?? ?? ?? 89 C5 8D 44 24 ?? 66 89 7C 24 ?? 31 FF
        }

        $kill_processes_v2_p1 = {
            41 54 BA ?? ?? ?? ?? B9 ?? ?? ?? ?? 45 31 E4 48 B8 ?? ?? ?? ?? ?? ?? ?? ?? 55 48 89
            FD 53 48 81 EC ?? ?? ?? ?? 66 0F 6F 05 ?? ?? 00 00 48 89 84 24 ?? ?? ?? ?? B8 ?? ??
            ?? ?? 48 8D 9C 24 ?? ?? ?? ?? 48 8D B4 24 ?? ?? ?? ?? 0F 29 84 24 ?? ?? ?? ?? 66 0F
            6F 05 ?? ?? 00 00 48 89 DF 66 89 44 24 ?? 48 B8 ?? ?? ?? ?? ?? ?? ?? ?? 0F 29 44 24
            ?? 66 0F 6F 05 ?? ?? 00 00 66 89 54 24 ?? 48 89 EA 0F 29 44 24 ?? 66 0F 6F 05 ?? ??
            00 00 66 89 8C 24 ?? ?? 00 00 B9 ?? ?? ?? ?? 0F 29 44 24 ?? 66 0F 6F 05 ?? ?? 00 00
            C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 0F 29 84 24 ?? ?? ?? ?? 66 0F 6F 05 ?? ?? 00 00 C6
            84 24 ?? ?? ?? ?? ?? 0F 29 84 24 ?? ?? ?? ?? 66 0F 6F 05 ?? ?? 00 00 C7 44 24 ?? ??
            ?? ?? ?? 0F 29 84 24 ?? ?? ?? ?? 66 0F 6F 05 ?? ?? 00 00 C6 44 24 ?? ?? 0F 29 84 24
            ?? ?? ?? ?? C6 44 24 ?? ?? C7 44 24 ?? ?? ?? ?? ?? C6 44 24 ?? ?? C7 84 24 ?? ?? ??
            ?? ?? ?? ?? ?? C6 84 24 ?? ?? ?? ?? ?? 48 89 44 24 ?? 48 B8
        }

        $kill_processes_v2_p2 = {
            48 89 44 24 ?? 4C 89 E0 F3 48 AB 48 89 DF C6 44 24 ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7
            44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 4C 89 E0 48 89 DF B9 ??
            ?? ?? ?? F3 48 AB 48 8D 74 24 ?? 48 89 EA 48 89 DF E8 ?? ?? ?? ?? 48 89 DF E8 ?? ??
            ?? ?? 4C 89 E0 48 89 DF B9 ?? ?? ?? ?? F3 48 AB 48 8D 74 24 ?? 48 89 EA 48 89 DF E8
            ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 4C 89 E0 48 89 DF B9 ?? ?? ?? ?? F3 48 AB 48 8D
            74 24 ?? 48 89 EA 48 89 DF E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 4C 89 E0 48 89 DF
            B9 ?? ?? ?? ?? F3 48 AB 48 8D B4 24 ?? ?? ?? ?? 48 89 EA 48 89 DF E8 ?? ?? ?? ?? 48
            89 DF E8 ?? ?? ?? ?? 4C 89 E0 48 89 DF B9 ?? ?? ?? ?? F3 48 AB 48 8D 74 24 ?? 48 89
            EA 48 89 DF E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 4C 89 E0 48 89 DF B9 ?? ?? ?? ??
            F3 48 AB 48 8D 74 24 ?? 48 89 EA 48 89 DF E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48
            81 C4 ?? ?? ?? ?? 5B 5D 41 5C C3
        }

        $encrypt_files_v2_p1 = {
            48 B8 ?? ?? ?? ?? ?? ?? ?? ?? 41 57 66 0F EF C0 49 89 FF 41 56 49 89 D6 41 55 49 89
            F5 BE ?? ?? ?? ?? 41 54 55 53 48 81 EC ?? ?? ?? ?? 48 8D 5C 24 ?? 48 89 4C 24 ?? 48
            8D AC 24 ?? ?? ?? ?? 48 89 DF 4C 89 04 24 0F 29 44 24 ?? 0F 29 44 24 ?? 0F 29 44 24
            ?? 48 C7 44 24 ?? ?? ?? ?? ?? 0F 29 44 24 ?? 48 89 44 24 ?? E8 ?? ?? ?? ?? 85 C0 75
            ?? 45 31 E4 48 89 EF BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 DF BE ?? ?? ?? ?? E8 ?? ??
            ?? ?? 48 8D 7B ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? 44 89 E0 5B 5D
            41 5C 41 5D 41 5E 41 5F C3 0F 1F 80 ?? ?? ?? ?? 48 8D 7B ?? BE ?? ?? ?? ?? E8 ?? ??
            ?? ?? 85 C0 74 ?? BA ?? ?? ?? ?? 48 89 DE 48 89 EF E8 ?? ?? ?? ?? 48 8D 35 ?? ?? ??
            ?? 4C 89 FF E8 ?? ?? ?? ?? 48 89 44 24 ?? 48 85 C0 0F 84 ?? ?? ?? ?? 4C 89 FF E8 ??
            ?? ?? ?? 4C 89 FE 4C 89 EF 48 89 C2 49 89 C4 E8 ?? ?? ?? ?? 8B 54 24 ?? 4B 8D 44 25
            ?? 31 F6 89 10 0F B7 54 24 ?? 66 89 50 ?? 0F B6 54 24 ?? 88 50 ?? BA ?? ?? ?? ?? 43
            C6 44 25 ?? ?? 4C 8B 64 24 ?? 4C 89 E7 E8 ?? ?? ?? ?? 4C 89 E7 4C 89 64 24 ?? 45 31
            E4 E8 ?? ?? ?? ?? 48 83 F8 ?? 7E ?? 4C 89 EE 4C 89 FF E8 ?? ?? ?? ?? 85 C0 74 ?? 48
            8B 7C 24 ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 66 0F 1F 44 00 ?? 48 8B 7C 24 ?? E8 ?? ??
            ?? ?? 48 8D 35 ?? ?? ?? ?? 4C 89 EF E8 ?? ?? ?? ?? 48 89 44 24 ?? 49 89 C4 48 85 C0
        }

        $encrypt_files_v2_p2 = {
            0F 84 ?? ?? ?? ?? 31 F6 BA ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 4C 89 E7 4C 89 64 24
            ?? E8 ?? ?? ?? ?? 48 39 44 24 ?? 48 0F 4E 44 24 ?? 48 8D 7C 24 ?? 48 89 C1 48 C1 F9
            ?? 48 C1 E9 ?? 48 8D 14 08 83 E2 ?? 48 29 CA 48 29 D0 48 89 44 24 ?? E8 ?? ?? ?? ??
            48 8D BC 24 ?? ?? ?? ?? B9 ?? ?? ?? ?? 48 89 DE 48 89 44 24 ?? 31 C0 BA ?? ?? ?? ??
            F3 48 AB 48 8D 84 24 ?? ?? ?? ?? 48 8B 3C 24 48 89 C1 48 89 44 24 ?? E8 ?? ?? ?? ??
            41 89 C4 85 C0 0F 84 ?? ?? ?? ?? 48 8B 7C 24 ?? E8 ?? ?? ?? ?? 48 8B 7C 24 ?? 4C 89
            EE E8 ?? ?? ?? ?? 41 89 C4 85 C0 0F 84 ?? ?? ?? ?? 48 8B 44 24 ?? 4C 8D 64 24 ?? 48
            85 C0 75 ?? E9 ?? ?? ?? ?? 0F 1F 80 ?? ?? ?? ?? 4D 89 F1 4D 89 E8 4C 89 E9 4C 89 E2
            48 89 EE 48 8D 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 89 F6 BA ?? ?? ?? ?? 4C 89 FF 48 F7
            DE E8 ?? ?? ?? ?? 4C 89 F9 4C 89 F2 BE ?? ?? ?? ?? 4C 89 EF E8 ?? ?? ?? ?? 48 8B 44
            24 ?? 4C 29 F0 48 89 44 24 ?? 74 ?? 49 39 C6 4C 8B 7C 24 ?? BE ?? ?? ?? ?? 4C 89 EF
            4C 0F 47 F0 66 0F 6F 4C 24 ?? 4C 89 F9 4C 89 F2 0F 29 4C 24 ?? E8 ?? ?? ?? ?? 4C 39
            F0 74 ?? 48 8B 7C 24 ?? 41 BC ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 4C 89 FE 4C
            89 EF E8 ?? ?? ?? ?? E9
        }

        $find_files_v2_p1 = {
            41 57 4D 89 C7 41 56 49 89 FE 41 55 49 89 FD 41 54 55 53 89 CB 48 81 EC ?? ?? ?? ??
            48 89 34 24 89 54 24 ?? 41 8B 55 ?? 49 83 C5 ?? 8D 82 ?? ?? ?? ?? F7 D2 21 D0 25 ??
            ?? ?? ?? 74 ?? 89 C2 C1 EA ?? A9 ?? ?? ?? ?? 0F 44 C2 49 8D 55 ?? 4C 0F 44 EA 89 C6
            40 00 C6 49 83 DD ?? 31 ED 4D 29 F5 74 ?? 49 8D 6D ?? 43 80 7C 2E ?? ?? 49 0F 45 ED
            48 8D 44 24 ?? 41 89 DC 4C 89 F6 48 89 44 24 ?? 48 89 C2 BF ?? ?? ?? ?? 41 83 E4 ??
            0F 84 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 00 83 F8
            ?? 0F 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 45 31 DB 41 BC ?? ?? ?? ?? 48 8B 44 24 ?? F6 C3
            ?? 0F 85 ?? ?? ?? ?? 48 89 44 24 ?? 48 8B 44 24 ?? 4C 89 7C 24 ?? 48 89 44 24 ?? 4D
            85 FF 0F 84 ?? ?? ?? ?? 41 8B 47 ?? 8D 55 ?? 89 54 24 ?? 83 C0 ?? 89 44 24 ?? 89 44
            24 ?? 41 8B 47 ?? 89 44 24 ?? 45 31 C0 C7 44 24 ?? ?? ?? ?? ?? 83 F9 ?? 0F 84 ?? ??
            ?? ?? 89 D8 83 E0 ?? 89 44 24 ?? 75 ?? 44 88 5C 24 ?? 44 89 E2 48 8D 4C 24 ?? 4C 89
            F7 48 8B 74 24 ?? 48 8B 04 24 44 89 44 24 ?? FF D0 44 8B 44 24 ?? 44 0F B6 5C 24 ??
            85 C0 89 C2 75 ?? 4D 85 FF 0F 84 ?? ?? ?? ?? 48 8B 44 24 ?? 48 8B 54 24 ?? EB ?? 0F
            1F 44 00 ?? 4D 8B 3F 4D 85 FF 0F 84 ?? ?? ?? ?? 49 39 47 ?? 75 ?? 49 39 57 ?? 75 ??
            31 D2 48 81 C4 ?? ?? ?? ?? 89 D0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 90 E8 ?? ?? ??
            ?? 85 C0 78 ?? 8B 44 24 ?? 25 ?? ?? ?? ?? 3D ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 3D ?? ??
            ?? ?? 0F 84 ?? ?? ?? ?? 31 C9 45 31 DB 45 31 E4 48 8B 44 24 ?? F6 C3 ?? 0F 84 ?? ??
            ?? ?? 4D 85 FF 0F 84 ?? ?? ?? ?? 49 39 47 ?? 75 ?? 48 89 44 24 ?? 48 8B 44 24 ?? 4C
        }

        $find_files_v2_p2 = {
            89 7C 24 ?? 48 89 44 24 ?? E9 ?? ?? ?? ?? 66 2E 0F 1F 84 00 ?? ?? 00 00 E8 ?? ?? ??
            ?? 49 89 C4 8B 00 83 F8 ?? 0F 85 ?? ?? ?? ?? 48 8B 54 24 ?? 4C 89 F6 BF ?? ?? ?? ??
            E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 45 31 DB 41 BC ?? ?? ?? ?? EB
            ?? 0F 1F 00 8B 4C 24 ?? 85 C9 74 ?? 45 84 DB 0F 85 ?? ?? ?? ?? 8B 44 24 ?? 43 C6 04
            2E ?? 85 C0 0F 84 ?? ?? ?? ?? 44 89 E2 48 8D 4C 24 ?? 48 8B 74 24 ?? 4C 89 F7 48 8B
            04 24 FF D0 89 C2 E9 ?? ?? ?? ?? 90 31 F6 4C 89 F7 31 C0 44 88 5C 24 ?? E8 ?? ?? ??
            ?? 89 44 24 ?? E8 ?? ?? ?? ?? 8B 7C 24 ?? 44 0F B6 5C 24 ?? 44 8B 00 85 FF 79 ?? 41
            83 F8 ?? BA ?? ?? ?? ?? 0F 94 C0 84 C0 B8 ?? ?? ?? ?? 44 0F 45 DA 44 0F 45 E0 8B 74
            24 ?? 85 F6 0F 85 ?? ?? ?? ?? 8B 7C 24 ?? 44 88 5C 24 ?? 44 89 44 24 ?? E8 ?? ?? ??
            ?? 44 0F B6 5C 24 ?? 44 8B 44 24 ?? E9 ?? ?? ?? ?? 0F 1F 00 48 89 44 24 ?? 48 8B 44
            24 ?? 48 C7 44 24 ?? ?? ?? ?? ?? 48 89 44 24 ?? 8D 45 ?? C7 44 24 ?? ?? ?? ?? ?? 89
            44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 48 85 ED 74 ?? 41 80 3C 2E ?? 48 89 E8 74 ?? E9 ??
            ?? ?? ?? 0F 1F 44 00 ?? 41 80 3C 06 ?? 0F 85 ?? ?? ?? ?? 48 83 E8 ?? 75 ?? 31 D2 89
        }

        $find_files_v2_p3 = {
            54 24 ?? E9 ?? ?? ?? ?? 0F 1F 40 ?? 89 D8 B9 ?? ?? ?? ?? 41 BB ?? ?? ?? ?? 83 E0 ??
            83 F8 ?? 45 19 E4 41 83 E4 ?? 41 83 C4 ?? E9 ?? ?? ?? ?? 0F 1F 44 00 ?? 8B 54 24 ??
            85 D2 0F 88 ?? ?? ?? ?? 8B 7C 24 ?? E8 ?? ?? ?? ?? 49 89 C7 48 85 C0 0F 84 ?? ?? ??
            ?? B8 ?? ?? ?? ?? 44 89 64 24 ?? 4C 29 E8 48 89 44 24 ?? 48 8D 44 24 ?? 48 89 44 24
            ?? 8B 44 24 ?? 83 E8 ?? 89 44 24 ?? 4C 89 FF E8 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ??
            ?? 80 78 ?? ?? 74 ?? 4C 8D 60 ?? 4C 89 E7 E8 ?? ?? ?? ?? 48 3B 44 24 ?? 0F 83 ?? ??
            ?? ?? 41 C6 04 2E ?? 49 8D 7C 2E ?? 4C 89 E6 E8 ?? ?? ?? ?? 4C 8B 44 24 ?? 8B 54 24
            ?? 89 D9 48 8B 34 24 4C 89 F7 E8 ?? ?? ?? ?? 85 C0 74 ?? 4C 89 FF 89 04 24 E8 ?? ??
            ?? ?? 8B 14 24 E9 ?? ?? ?? ?? 66 90 80 78 ?? ?? 74 ?? 66 83 78 ?? ?? 75 ?? EB ?? 90
            41 80 7C 06 ?? ?? 48 8D 70 ?? 89 C2 0F 84 ?? ?? ?? ?? 48 85 F6 0F 84 ?? ?? ?? ?? 41
            80 7C 06 ?? ?? 48 8D 50 ?? 75 ?? E9 ?? ?? ?? ?? 0F 1F 40 ?? 48 89 C2 48 85 D2 0F 84
            ?? ?? ?? ?? 41 80 7C 16 ?? ?? 48 8D 42 ?? 75 ?? E9 ?? ?? ?? ?? 0F 1F 00 45 85 E4 0F
            84 ?? ?? ?? ?? 31 C9 45 31 DB 41 BC ?? ?? ?? ?? E9 ?? ?? ?? ?? 4C 89 FF 44 8B 64 24
            ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 41 8B 04 24 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 89 FF
            C7 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? E9 ?? ?? ?? ?? BA ?? ?? ?? ?? E9 ??
            ?? ?? ?? 48 89 F2 E9 ?? ?? ?? ?? 44 89 04 24 E8 ?? ?? ?? ?? 44 8B 04 24 BA ?? ?? ??
            ?? 44 89 00 E9 ?? ?? ?? ?? 8B 7C 24 ?? E8 ?? ?? ?? ?? 83 CA ?? E9
        }

        $init_key_v2 = {
            48 85 FF 0F 84 ?? ?? ?? ?? 48 85 F6 0F 84 ?? ?? ?? ?? 41 56 41 55 41 54 55 48 89 F5
            53 48 89 FB 48 81 EC ?? ?? ?? ?? 4C 8D 64 24 ?? 4C 89 E7 E8 ?? ?? ?? ?? 85 C0 75 ??
            66 0F EF C0 48 8D 35 ?? ?? ?? ?? 48 8D 3D ?? ?? ?? ?? 49 89 E6 0F 29 04 24 0F 29 44
            24 ?? E8 ?? ?? ?? ?? 49 89 C5 48 85 C0 74 ?? 4C 89 F7 48 89 C1 BA ?? ?? ?? ?? BE ??
            ?? ?? ?? E8 ?? ?? ?? ?? 4C 89 EF E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 4C 89 F6 4C 89 E7 E8
            ?? ?? ?? ?? 85 C0 74 ?? 31 C0 48 81 C4 ?? ?? ?? ?? 5B 5D 41 5C 41 5D 41 5E C3 66 2E
            0F 1F 84 00 ?? ?? 00 00 31 C0 C3 0F 1F 44 00 ?? 48 89 EA 48 89 DE 4C 89 E7 E8 ?? ??
            ?? ?? 85 C0 75 ?? 4C 89 E7 E8 ?? ?? ?? ?? 89 E8 EB
        }

    condition:
        uint32(0) == 0x464C457F and
        (
            (
                (
                    all of ($find_files_v1_p*)
                ) and
                (
                    all of ($kill_processes_v1_p*)
                ) and
                (
                    $init_key_v1
                ) and
                (
                    all of ($encrypt_files_v1_p*)
                ) and
                (
                    $shut_down_esxi_v1
                )
            ) or
            (
                (
                    all of ($find_files_v2_p*)
                ) and
                (
                    all of ($kill_processes_v2_p*)
                ) and
                (
                    $init_key_v2
                ) and
                (
                    all of ($encrypt_files_v2_p*)
                )
            )
        )
}